<?php declare(strict_types = 1);

namespace MeasuringCodes\DI;

use Override;
use Nette\DI\Definitions\ServiceDefinition;
use Core\DI\CompilerExtension;
use Nette;
use Nette\PhpGenerator\ClassType;
use function str_contains;

class  MeasuringCodesExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['MeasuringCodes' => 'MeasuringCodes\*Module\Presenters\*Presenter']);
		$builder = $this->getContainerBuilder();

		$factories = [
			'default' => $builder->getDefinition('measuringCodes.front.typeControlFactory'),
		];
		foreach ($builder->parameters['measuringCodes']['typesList'] as $k => $row) {
			if (isset($row['factory'])) {
				if (str_contains((string) $row['factory'], '.')) {
					$factory = $builder->getDefinition($row['factory']);
				} else {
					$factory = $builder->getDefinitionByType($row['factory']);
				}

				$factories[$k] = $factory;
			}
		}

		/** @var ServiceDefinition $def */
        $def = $builder->getDefinition('measuringCodes.front.typesList');
		$def->addSetup('setFactories', [$factories]);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('MeasuringCodes\Model\MeasuringCodesConfig::setParams($this->parameters[\'measuringCodes\']);');
	}
}
