<?php declare(strict_types = 1);

namespace MeasuringCodes\ErrorModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\ErrorPresenter;
use Core\Model\UI\FrontPresenter;
use MeasuringCodes\FrontModule\Components\TypeControlFactory;
use MeasuringCodes\FrontModule\Model\Dao\GoogleAdsType;
use MeasuringCodes\FrontModule\Model\TypesList;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ErrorPresenterSubscriber implements EventSubscriberInterface
{
	public function __construct(protected TypeControlFactory $typeControlFactory, protected TypesList $typesList)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ErrorPresenter::class . '::beforeRender' => 'beforeRender',
		];
	}

	/**
	 * Vložení obecných kódů na všechny stránky
	 */
	public function beforeRender(ControlEvent $event): void
	{
		/** @var FrontPresenter $presenter */
		$presenter = $event->control;

		// Vlozeni obechnych na kazdou stranku
		foreach ($this->typesList->getTypes() as $type) {
			if (!$type->isActive() || empty($type->getPositions()))
				continue;

			foreach ($type->getPositions() as $pos) {
				if ($pos === 'head') {
					$component = $this->typeControlFactory->create($type);
					$presenter->addHeadComponent($component, $type->getKey());

					if ($type->getKey() === 'googleAnalytics') {
						/** @var GoogleAdsType|null $googleAdsType */
						$googleAdsType = $this->typesList->getType('googleAds');

						if ($googleAdsType && $googleAdsType->isActive()) {
							$component->setParam('googleAdsType', $googleAdsType);
							$component->setParam('googleAdsId', $googleAdsType->getFullId());
							$component->setParam(
								'googleAdsEnhanced',
								$googleAdsType->getFieldValue('allowEnhancedConversions'),
							);
						}
					}
				} else if ($pos === 'bodyStart') {
					$presenter->addBodyStartComponent($this->typeControlFactory->create($type), $type->getKey());
				} else if ($pos === 'bodyEnd') {
					$presenter->addBodyEndComponent($this->typeControlFactory->create($type), $type->getKey());
				}
			}
		}
	}
}
