<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class BingEventControl extends BaseControl
{
	protected Type $type;

	protected string $pushType;
	public ?string   $eventName  = null;
	protected array  $data       = [];
	protected bool   $useSnippet = true;
	public ?string   $file       = 'event';

	public function __construct(Type $type, string $pushType)
	{
		$this->type     = $type;
		$this->pushType = $pushType;
	}

	public function render(): void
	{
		$file = $this->type->getTemplate($this->file);
		if (!$file) {
			return;
		}

		$this->template->type       = $this->type;
		$this->template->pushType   = $this->pushType;
		$this->template->eventName  = $this->eventName;
		$this->template->data       = $this->data;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->render($file);
	}

	public function getData(): array { return $this->data; }

	public function setData(array $data): void
	{
		$this->data = $data;
	}

	public function useSnippet(bool $use = true): void
	{
		$this->useSnippet = $use;
	}

	public function getType(): Type { return $this->type; }
}
