<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class GTagEventControl extends BaseControl
{
	protected array $data = [];

	protected bool $useSnippet = true;

	public ?string $file = null;

	public function __construct(protected Type $type, protected string $eventName)

	{
	}

	public function render(): void
	{
		$file = $this->type->getTemplate($this->file ?: 'event');
		if (!$file) {
			return;
		}

		$this->template->type       = $this->type;
		$this->template->eventName  = $this->eventName;
		$this->template->data       = $this->data;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->render($file);
	}

	public function getData(): array { return $this->data; }

	public function setData(array $data): void
	{
		$this->data = $data;
	}

	public function useSnippet(bool $use = true): void
	{
		$this->useSnippet = $use;
	}

	public function getType(): Type { return $this->type; }
}
