<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use MeasuringCodes\FrontModule\Model\Dao\Type;

class TypeControlFactory
{
	public function __construct(protected array $factories)
	{
	}

	public function create(Type $type): TypeControl
	{
		$key = $type->getKey();

		return $this->factories[$key] ? $this->factories[$key]->create($type) : $this->factories['default']->create(
			$type,
		);
	}
}
