<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components\Zbozi;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderFlag;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\Model\Helpers\TrackingHelper;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class OrderTracking extends BaseControl
{
	protected SessionSection $sessionSection;

	/**
     * @param Order $order
     */
    public function __construct(
		protected Type           $type,
		protected                $order,
		protected TrackingHelper $trackingHelperService,
		Session                  $session,
	)
	{
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}

	public function render(): void
	{
		if (!$this->order->hasFlag(OrderFlag::TYPE_QUESTIONING) || !$this->trackingHelperService->canSend('zboziConversion', $this->order->getId(),)) {
			return;
		}

		$this->template->order = $this->order;
		$this->template->type  = $this->type;

		$this->trackingHelperService->send('zboziConversion', $this->order->getId());
		$this->template->render($this->type->getTemplate('bodyEnd'));
	}
}
