<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Helpers;

use Core\FrontModule\Model\ABTest;
use Core\FrontModule\Presenters\BasePresenter;
use EshopOrders\FrontModule\Model\Customers;
use Exception;
use MeasuringCodes\FrontModule\Components\GTagEventControl;
use MeasuringCodes\FrontModule\Components\IGTagEventControlFactory;
use MeasuringCodes\FrontModule\Model\Dao\DefaultType;
use MeasuringCodes\FrontModule\Model\Dao\GoogleAdsType;
use MeasuringCodes\FrontModule\Model\TypesList;
use Nette\DI\Container;
use Users\Model\Security\User;

class Ga4Helper
{
	protected static bool              $pageViewSent          = false;
	protected static ?GTagEventControl $pageViewComponentGA4  = null;
	protected static ?GTagEventControl $pageViewComponentGAds = null;

	public function __construct(
		protected TypesList                $typesList,
		protected IGTagEventControlFactory $gTagEventControlFactory,
		protected ABTest                   $abTest,
		protected User                     $user,
		protected Container                $container,
	)
	{
	}

	public function isAllowed(): bool
	{
		return GTagEventHelper::getTypeGa4IfAllowed($this->typesList) !== null;
	}

	public function sendEvent(string $eventName, array $data, BasePresenter $presenter, ?string $componentNameSuffix = 'ga4', bool $strictEventName = false): ?GTagEventControl
	{
		$ga4Type = GTagEventHelper::getTypeGa4IfAllowed($this->typesList);
		if (!$ga4Type) {
			return null;
		}

		$component = GTagEventHelper::getComponent($presenter, $this->gTagEventControlFactory, $eventName, $ga4Type, $componentNameSuffix, $strictEventName);
		if ($component) {
			$component->useSnippet(false);
			if (!isset($data['send_to'])) {
				$data['send_to'] = $ga4Type->getFieldValue('ga4_id');
			}

			$component->setData($data);

			return $component;
		}

		return null;
	}

	public function sendPageView(string $pageType, BasePresenter $presenter): void
	{
		if (self::$pageViewSent) {
			return;
		}

		self::$pageViewSent = true;

		$baseData = [
			'page_title'    => $presenter['title']->getFullTitle(),
			'page_location' => $presenter->getHttpRequest()->getUrl()->getAbsoluteUrl(),
			'page_type'     => $pageType,
		];

		try {
			$activeNav = $presenter->getActiveNavigation();

			if ($activeNav && $activeNav->isHomepage) {
				$pageType = 'homepage';
			}
		} catch (Exception $e) {
		}

		if ($baseData['page_type'] === 'other' && $pageType !== 'other') {
			$baseData['page_type'] = $pageType;
		}

		if (!$baseData['page_title']) {
			$baseData['page_title'] = $presenter['title']->getFullTitle();
		}

		$abTests = $this->abTest->getActive();
		if ($abTests) {
			$baseData['ab_tests'] = $abTests;
		}

		if ($this->user->isLoggedIn() && $this->container->hasService('eshopOrders.front.customers')) {
			/** @var \Users\Model\Entities\User $user */
			$user = $this->user->getIdentity();

			/** @var Customers $customers */
			$customers = $this->container->getService('eshopOrders.front.customers');

			$customer = $customers->getByUser($user);
			if ($customer) {
				$group = $customer->getGroupCustomers();

				$baseData['customer_group']      = $group->name ?? '';
				$baseData['customer_group_type'] = $group->type ?? 'B2C';
			}
		}

		if (!self::$pageViewComponentGAds) {
			/** @var GoogleAdsType|null $gAdsType */
			$gAdsType = $this->typesList->getType('googleAds');

			/** @var DefaultType|null $mAnalyticsType */
			$mAnalyticsType = $this->typesList->getType('multihubAnalytics');

			if ($gAdsType && $gAdsType->isActive()) {
				$componentGAds = GTagEventHelper::getComponent(
					$presenter,
					$this->gTagEventControlFactory,
					'page_view',
					$gAdsType,
				);
				if ($componentGAds) {
					self::$pageViewComponentGAds = $componentGAds;
					$componentGAds->useSnippet(false);

					$componentGAds->setData($baseData + [
							'send_to' => $gAdsType->getFullId(),
						]
					);
				}
			} else if ($mAnalyticsType && $mAnalyticsType->isActive()) {
				$componentGAds = GTagEventHelper::getComponent($presenter, $this->gTagEventControlFactory, 'page_view', $mAnalyticsType);
				if ($componentGAds) {
					self::$pageViewComponentGAds = $componentGAds;
					$componentGAds->useSnippet(false);

					$componentGAds->setData($baseData);
				}
			}
		}
	}

}
