<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Subscribers;

use Core\FrontModule\Presenters\DefaultPresenter as CoreDefaultPresenter;
use Core\Model\Event\ControlEvent;
use EshopCatalog\FrontModule\Presenters\DefaultPresenter as EshopDefaultPresenter;
use MeasuringCodes\FrontModule\Model\Helpers\DataLayerHelper;
use MeasuringCodes\FrontModule\Model\Helpers\Ga4Helper;
use MeasuringCodes\FrontModule\Model\TypesList;
use MeasuringCodes\Model\MeasuringCodesEventSubscriber;

class SearchSubscriber extends MeasuringCodesEventSubscriber
{
	public function __construct(
		protected TypesList       $typesList,
		protected Ga4Helper       $ga4Helper,
		protected DataLayerHelper $dataLayerHelper,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			CoreDefaultPresenter::class . '::renderSearch'        => 'defaultRenderSearch',
			EshopDefaultPresenter::class . '::actionSearch'       => 'defaultRenderSearch',
			EshopDefaultPresenter::class . '::actionPersooSearch' => 'defaultRenderSearch',
		];
	}

	public function defaultRenderSearch(ControlEvent $event): void
	{
		if (!$this->isMeasuringCodesAllowed()) {
			return;
		}

		/** @var CoreDefaultPresenter|EshopDefaultPresenter $presenter */
		$presenter = $event->control;

		$query = urldecode((string) $presenter->getParameter('q'));

		if (!$query) {
			return;
		}

		$this->ga4Helper->sendEvent(
			'site_search',
			[
				'search_term' => $query,
			],
			$presenter,
		);
		$this->dataLayerHelper->sendEvent(
			'site_search',
			[
				'search_term' => $query,
			],
			$presenter,
		);

		$this->ga4Helper->sendPageView('search', $presenter);
		$this->dataLayerHelper->sendPageView('search', $presenter);
	}

}
