<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Zbozi;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class ZboziCache
{
	protected Cache $cache;

	public function __construct(
		Storage $storage
	)
	{
		$this->cache = new Cache($storage, 'zbozi');
	}

	public function getCache(): Cache
	{
		return $this->cache;
	}

	public function getShopRatingKey(string $key): string
	{
		return 'shopRating:' . $key;
	}

	public function clearShopRating(string $key): void
	{
		$this->getCache()->remove($this->getShopRatingKey($key));
	}
}