<?php declare(strict_types = 1);

namespace MeasuringCodes\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'measuring_codes__zbozi_shop_rating')]
#[ORM\Entity]
class ZboziShopRating
{
	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $id;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?string $updated = null;

	#[ORM\Column(type: Types::STRING, length: 10, nullable: true)]
	public ?string $rating = null;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['default' => 0])]
	public int $reviewsCount = 0;
}
