<?php declare(strict_types = 1);

namespace MeasuringCodes\Model;

use Core\Model\SystemConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

abstract class MeasuringCodesEventSubscriber implements EventSubscriberInterface
{
	protected function isMeasuringCodesAllowed(): bool
	{
		return !((!MeasuringCodesConfig::load('enabledInTestMode', false) && SystemConfig::load('testMode')) || !MeasuringCodesConfig::load('enabled', false));
	}
}
