<?php declare(strict_types = 1);

namespace MeasuringCodes\Console\Ecomail;

use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use MeasuringCodes\Model\EcoMail;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Doctrine;
use Tracy\Debugger;

class ExportCustomers extends AbstractCommand
{
	protected EcoMail $ecoMail;

	public function __construct(
		EcoMail $ecoMail
	)
	{
		$this->ecoMail = $ecoMail;

		parent::__construct();
	}

	protected function configure(): void
	{
		$this->setName('measuringcodes:ecomail:export-customers')
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED);
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('ECOMAIL - Export Customers');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$this->ecoMail->exportCustomers((string) $input->getOption('site'), (string) $input->getOption('lang'));

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
