<?php declare(strict_types = 1);

namespace MeasuringCodes\Console\Zbozi;

use Core\Model\Helpers\Strings;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use MeasuringCodes\Model\Zbozi\RatingService;
use Nette\Utils\Json;
use Nettrine\ORM\EntityManagerDecorator;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class ZboziRatingDownload extends AbstractCommand
{
	protected RatingService $ratingService;
	protected EntityManagerDecorator $em;

	public function __construct(
		RatingService $ratingService,
		EntityManagerDecorator $em,
		?string $name = null
	)
	{
		parent::__construct($name);
		$this->ratingService = $ratingService;
		$this->em = $em;
	}

	protected function configure(): void
	{
		$this->setName('measuring-codes:zbozi:zbozi-rating-download');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Zbozi rating download');

		try {
			$conn = $this->em->getConnection();
			$preKey = 'measuringCodes';
			$postKey = 'ZboziConversion';
			$params = $conn->fetchAllAssociative("SELECT `key`, `value` FROM core__setting WHERE `key` LIKE '$preKey%' AND `key` LIKE '%$postKey'");

			foreach ($params as $row) {
				$site = null;
				if ($key = Strings::match($row['key'], "/$preKey(.*?)$postKey/")) {
					$site = Strings::firstLower($key[1]);
				}

				$data = Json::decode($row['value'], Json::FORCE_ARRAY);
				if (
					!$site
					|| !array_key_exists('cs', $data)
					|| !isset($data['cs']['apiKey'], $data['cs']['id_provozovny'])
					|| !$data['cs']['apiKey']
					|| !$data['cs']['id_provozovny']
				) {
					continue;
				}

				$apiKey = $data['cs']['apiKey'];
				$shopId = $data['cs']['id_provozovny'];

				$this->ratingService->downloadRating($site, $apiKey, $shopId);
			}

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}