<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;

class DataLayerControl extends BaseControl
{
	protected array $data = [];

	public bool $useSnippet = true;

	public string $varKey = 'dataLayer';

	public function __construct()
	{
	}

	public function render(): void
	{
		$this->template->useSnippet = $this->useSnippet;
		$this->template->data       = $this->data;
		$this->template->varKey     = $this->varKey;
		$this->template->render($this->getTemplateFile());
	}

	public function setData(array $data): void
	{
		$this->data = $data;
	}

	public function setGTagData(array $data): void
	{
		$this->varKey = 'gtag';
		$this->data   = $data;
	}
}
