<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\Providers\BaseComponentPack;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\FrontModule\Model\TypesList;

abstract class TypeControl extends BaseComponentPack
{
	protected Type      $type;
	protected TypesList $typesList;
	public bool         $useSnippet = false;

	protected array $templateParams = [];

	public function __construct(Type $type, TypesList $typesList)
	{
		$this->type      = $type;
		$this->typesList = $typesList;
	}

	public function render(): void
	{
		$file = $this->type->getTemplate($this->renderFile);
		if (!$file) {
			return;
		}

		$this->template->setParameters($this->templateParams);
		$this->template->type       = $this->type;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->render($file);
	}

	/**
	 * @param mixed $value
	 */
	public function setParam(string $key, $value): self
	{
		$this->templateParams[$key] = $value;

		return $this;
	}

	public function getOtherTypeIfIsAllowed(string $typeName): ?Type
	{
		$type = $this->typesList->getType($typeName);

		return $type && $type->isActive() ? $type : null;
	}
}
