<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components\Zbozi;

use EshopOrders\Model\Entities\OrderFlag;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Order;
use MeasuringCodes\Model\Helpers\TrackingHelper;

class OrderTracking extends BaseControl
{
	protected Type $type;

	protected Order $order;

	protected TrackingHelper $trackingHelperService;

	protected SessionSection $sessionSection;

	public function __construct(Type $type, Order $order, TrackingHelper $trackingHelper, Session $session)
	{
		$this->type                  = $type;
		$this->order                 = $order;
		$this->trackingHelperService = $trackingHelper;
		$this->sessionSection        = $session->getSection('eshopOrdersOrderForm');
	}

	public function render(): void
	{
		if (!$this->order->hasFlag(OrderFlag::TYPE_QUESTIONING) || !$this->trackingHelperService->canSend('zboziConversion', $this->order->getId()))
			return;

		$this->template->order = $this->order;
		$this->template->type  = $this->type;

		$this->trackingHelperService->send('zboziConversion', $this->order->getId());
		$this->template->render($this->type->getTemplate('bodyEnd'));
	}
}
