<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Dao;

class Field
{
	protected string $key;

	protected string $type;

	protected ?string $value = null;

	public function __construct(string $key, string $type, ?string $value)
	{
		$this->key   = $key;
		$this->type  = $type;
		$this->value = $value;
	}

	public function getKey(): string { return $this->key; }

	public function getType(): string { return $this->type; }

	public function getValue(): ?string { return $this->value; }
}
