<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Dao;

class GoogleAdsType extends Type
{
	public function getFullId(): string
	{
		return 'AW-' . $this->getFieldValue('ads_id');
	}

	public function getFullConversionId(): string
	{
		return $this->getFullId() . '/' . $this->getFieldValue('conversionLabel');
	}

	public function getFullPhoneId(): string
	{
		return $this->getFullId() . '/' . $this->getFieldValue('phoneLabel');
	}

	public function getB2CGroups(): array
	{
		$groups = $this->getFieldValue('b2CGroups');

		if (is_string($groups)) {
			return array_map('trim', explode(',', $groups));
		}

		return [];
	}

	public function getConversionLabelB2C(): ?string
	{
		$label = $this->getFieldValue('conversionLabelB2C');

		return $label ? $this->getFullId() . '/' . $label : null;
	}

	public function getConversionLabelAcqB2C(): ?string
	{
		$label = $this->getFieldValue('conversionLabelAcqB2C');

		return $label ? $this->getFullId() . '/' . $label : null;
	}

	public function getConversionLabelRetB2C(): ?string
	{
		$label = $this->getFieldValue('conversionLabelRetB2C');

		return $label ? $this->getFullId() . '/' . $label : null;
	}
}
