<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\FrontPresenter;
use EshopOrders\FrontModule\Presenters\DefaultPresenter;
use MeasuringCodes\FrontModule\Components\TypeControlFactory;
use MeasuringCodes\FrontModule\Model\TypesList;
use MeasuringCodes\Model\MeasuringCodesEventSubscriber;

class FoxentrySubscriber extends MeasuringCodesEventSubscriber
{
	protected TypeControlFactory $typeControlFactory;
	protected TypesList          $typesList;

	public function __construct(
		TypeControlFactory $typeControlFactory,
		TypesList          $typesList
	)
	{
		$this->typeControlFactory = $typeControlFactory;
		$this->typesList          = $typesList;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			DefaultPresenter::class . '::renderorder' => 'renderOrder',
		];
	}

	public function renderOrder(ControlEvent $event): void
	{
		/** @var FrontPresenter|null $presenter */
		$presenter = $event->control->getPresenter();
		$foxentry  = $this->typesList->getType('foxentry');

		if (!$presenter || !$foxentry || !$foxentry->isActive()) {
			return;
		}

		$presenter->addBodyEndComponent($this->typeControlFactory->create($foxentry), $foxentry->getKey());
	}

}