<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use MeasuringCodes\FrontModule\Model\Helpers\DataLayerHelper;
use MeasuringCodes\FrontModule\Model\Helpers\Ga4Helper;
use MeasuringCodes\FrontModule\Model\TypesList;
use MeasuringCodes\Model\MeasuringCodesEventSubscriber;
use Pages\FrontModule\Presenters\DefaultPresenter;

class PagesSubscriber extends MeasuringCodesEventSubscriber
{
	protected TypesList       $typesList;
	protected Ga4Helper       $ga4Helper;
	protected DatalayerHelper $dataLayerHelper;

	public function __construct(
		TypesList       $typesList,
		Ga4Helper       $ga4Helper,
		DataLayerHelper $dataLayerHelper
	)
	{
		$this->typesList       = $typesList;
		$this->ga4Helper       = $ga4Helper;
		$this->dataLayerHelper = $dataLayerHelper;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			DefaultPresenter::class . '::beforeRender' => 'beforeRender',
		];
	}

	public function beforeRender(ControlEvent $event): void
	{
		if (!$this->isMeasuringCodesAllowed()) {
			return;
		}

		/** @var DefaultPresenter $presenter */
		$presenter = $event->control;

		$this->ga4Helper->sendPageView('page', $presenter);
		$this->dataLayerHelper->sendPageView('page', $presenter);
	}
}
