<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Zbozi;

use Core\Model\Entities\EntityManagerDecorator;
use Nette\Caching\Cache;

class RatingService
{
	protected EntityManagerDecorator $em;
	protected ZboziCache             $zboziCache;

	public function __construct(EntityManagerDecorator $em, ZboziCache $zboziCache)
	{
		$this->em         = $em;
		$this->zboziCache = $zboziCache;
	}

	public function getRating(string $key): ?array
	{
		return $this->zboziCache->getCache()->load($this->zboziCache->getShopRatingKey($key), function(&$dep) use ($key) {
			$dep = [
				Cache::EXPIRE => '1 week',
			];

			$data = $this->em->getConnection()->fetchAssociative("SELECT rating, reviews_count FROM measuring_codes__zbozi_shop_rating WHERE id = ? LIMIT 1", [$key]);

			if ($data) {
				return [
					'rating'        => (float) $data['rating'],
					'reviews_count' => (int) $data['reviews_count'],
				];
			}

			return [];
		}) ?: null;
	}

}