<?php declare(strict_types = 1);

namespace MeasuringCodes\Model\Helpers;

use Core\Model\Helpers\BaseService;
use Nette\Http\SessionSection;
use Nette\SmartObject;
use Nette\Http\Session;

class TrackingHelper extends BaseService
{
	use SmartObject;

	protected SessionSection $sessionSection;

	public function __construct(Session $session)
	{
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}

	/** Zkontroluje, jestli konkretni merici kod uz byl odeslan
	 *
	 * @param string $type typ konverze, napr Heureka, Zbozi, GA
	 * @param int $orderId ID objednavky
	 */
	public function canSend(string $type, int $orderId): bool
	{
		if (empty($this->sessionSection->conversionSent[$type][$orderId])) {
			return true;
		}

		return false;
	}

	/** Nastavi do session priznak, ze tento konkretni konverzni kod uz byl odeslan.
	 *
	 * @param string $type konverze, napr Heureka, Zbozi, GA
	 * @param int $orderId ID objednavky
	 */
	public function send(string $type, int $orderId): void
	{
		if (!is_array($this->sessionSection->conversionSent[$type])) {
			$this->sessionSection->conversionSent[$type] = [];
		}
		$this->sessionSection->conversionSent[$type][$orderId] = true;
	}

	public function clear():void {
		$this->sessionSection->remove('conversionSent');
	}
}

