<?php declare(strict_types = 1);

namespace MeasuringCodes\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use MeasuringCodes\Model\EcoMail;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class EcomailCheckInactive extends AbstractCommand
{
	/** @var EcoMail @inject */
	public $ecoMail = null;

	protected function configure(): void
	{
		$this->setName('measuringcodes:ecomail:checkInactive')
			->addOption('days', null, InputOption::VALUE_REQUIRED)
			->addOption('length', null, InputOption::VALUE_REQUIRED)
			->addOption('list', null, InputOption::VALUE_REQUIRED)
			->addOption('tag', null, InputOption::VALUE_OPTIONAL);
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	): int
	{
		$output->writeln('ECOMAIL CHECK INACTIVE');

		try {
			ini_set('memory_limit', '5G');
			Debugger::dispatch();

			$this->ecoMail->checkInactive(
				(int) $input->getOption('days'),
				(int) $input->getOption('length'),
				(int) $input->getOption('list'),
				$input->getOption('tag'),
			);

			$output->writeLn('<info>[OK] - checked</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
