<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class EcoTrackControl extends BaseControl
{
	public ?string $eventName  = null;
	public array   $data       = [];
	public bool    $useSnippet = false;
	public ?string $renderFile = null;

	public function __construct(protected Type $type)
	{
	}

	public function render(): void
	{
		if ($this->renderFile === null) {
			if ($this->eventName === 'trackStructEvent') {
				$this->renderFile = 'ecoTrackStruct';
			} else {
				$this->renderFile = 'ecoTrack';
			}
		}

		$file = $this->type->getTemplate($this->renderFile);
		if (!$file) {
			return;
		}

		$this->template->type       = $this->type;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->eventName  = $this->eventName;
		$this->template->data       = $this->data;
		$this->template->render($file);
	}
}
