<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class FBPixelEventControl extends BaseControl
{
	protected string $eventName;

	protected ?array $code3 = null;

	protected bool $shoOnlyIfCode3 = false;

	protected array $data = [];

	public function __construct(protected Type $type, protected string $code2, protected string $code1)
	{
	}

	public function render(): void
	{
		$file = $this->type->getTemplate('event');
		if (!$file)
			return;

		$this->template->type            = $this->type;
		$this->template->code1           = $this->code1;
		$this->template->code2           = $this->code2;
		$this->template->code3           = $this->code3;
		$this->template->showOnlyIfCode3 = $this->shoOnlyIfCode3;
		$this->template->render($file);
	}

	public function setCode3(array $code3): self
	{
		$this->code3 = $code3;

		return $this;
	}

	public function showOnlyIfCode3(bool $v = true): self
	{
		$this->shoOnlyIfCode3 = $v;

		return $this;
	}
}
