<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\Providers\BaseComponentPack;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\FrontModule\Model\TypesList;

abstract class TypeControl extends BaseComponentPack
{
	public bool $useSnippet = false;

	protected array $templateParams = [];

	public function __construct(protected Type $type, protected TypesList $typesList)
	{
	}

	public function render(): void
	{
		$file = $this->type->getTemplate($this->renderFile);
		if (!$file)
			return;

		$this->template->setParameters($this->templateParams);
		$this->template->type       = $this->type;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->render($file);
	}

	public function setParam(string $key, mixed $value): self
	{
		$this->templateParams[$key] = $value;

		return $this;
	}

	public function getOtherTypeIfIsAllowed(string $typeName): ?Type
	{
		$type = $this->typesList->getType($typeName);

		return $type && $type->isActive() ? $type : null;
	}
}
