<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Dao;

use MeasuringCodes\FrontModule\Components\TypeControlFactory;

abstract class Type
{
	/** Merici kod se vypisuje na stranku, ale nespousti se */
	protected bool $turnOff = false;

	/** @var Field[] */
	protected array $fields = [];

	public array $rawFields = [];

	/** @var null|TypeControlFactory */
	public $factory = null;

	public function __construct(
		protected string $key,
		protected string $name,
		protected bool   $isActive,
		protected array  $positions,
		protected array  $templates = [],
	)
	{
	}

	public function getKey(): string { return $this->key; }

	public function getName(): string { return $this->name; }

	public function isActive(): bool { return $this->isActive; }

	public function isTurnOff(): bool { return $this->turnOff; }

	public function addField(Field $field): void
	{
		$this->fields[$field->getKey()] = $field;
	}

	public function setActive(bool $active = true): void
	{
		$this->isActive = $active;
	}

	public function turnOff(bool $turnOff = true): void
	{
		$this->turnOff = $turnOff;
	}

	/** @return Field[] */
	public function getFields(): array { return $this->fields; }

	public function getField(string $key): ?Field { return $this->fields[$key] ?? null; }

	public function getFieldValue(string $key): ?string
	{
		$field = $this->getField($key);

		return $field ? $field->getValue() : null;
	}

	public function getPositions(): array { return $this->positions; }

	public function getTemplate(string $fileName): ?string
	{
		if (isset($this->templates[$fileName])) {
			return $this->templates[$fileName];
		}

		$file = sprintf('%smeasuringCodes/%s/%s.latte', PACKAGE_MEASURINGCODES_DIR, $this->getKey(), $fileName);
		if (file_exists($file))
			return $file;

		return null;
	}
}
