<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Helpers;

use Core\FrontModule\Presenters\BasePresenter;
use MeasuringCodes\FrontModule\Components\EcoTrackControl;
use MeasuringCodes\FrontModule\Components\IEcoTrackControlFactory;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\FrontModule\Model\TypesList;
use MeasuringCodes\Model\MeasuringCodesConfig;

class EcoMailHelper
{
	protected static int $componentCount = 0;

	public function __construct(
		protected TypesList               $typesList,
		protected IEcoTrackControlFactory $ecoTrackControlFactory,
	)
	{
	}

	public function getType(): ?Type
	{
		$ecoMailType = $this->typesList->getType('ecoMail');

		if ($ecoMailType && $ecoMailType->isActive() && MeasuringCodesConfig::load(
				'typesList.ecoMail.enableTracking',
			)) {
			return $ecoMailType;
		}

		return null;
	}

	public function sendStructEvent(
		string        $category,
		string        $action,
		string        $label,
		string        $feature,
		string        $value,
		BasePresenter $presenter,
	): ?EcoTrackControl
	{
		$ecoMailType = $this->getType();
		if (!$ecoMailType) {
			return null;
		}

		$ecoMailCartComponent = $this->ecoTrackControlFactory->create($ecoMailType);

		$ecoMailCartComponent->eventName = 'trackStructEvent';
		$ecoMailCartComponent->data      = [$category, $action, $label, $feature, $value];

		$presenter->addBodyEndComponent($ecoMailCartComponent, $ecoMailType->getKey() . self::$componentCount);
		self::$componentCount++;

		return $ecoMailCartComponent;
	}

}
