<?php declare(strict_types = 1);

namespace MeasuringCodes\Model\Helpers;

use Core\Model\Helpers\BaseService;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use Nette\SmartObject;

class TrackingHelper extends BaseService
{
	use SmartObject;

	protected SessionSection $sessionSection;

	public function __construct(
		protected Session $session,
	)
	{
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}

	/** Zkontroluje, jestli konkretni merici kod uz byl odeslan
	 *
	 * @param string $type    typ konverze, napr Heureka, Zbozi, GA
	 * @param int    $orderId ID objednavky
	 */
	public function canSend(string $type, int $orderId): bool
	{
		$conversionSent = $this->sessionSection->get('conversionSent') ?: [];
		if (empty($conversionSent[$type][$orderId])) {
			return true;
		}

		return false;
	}

	/** Nastavi do session priznak, ze tento konkretni konverzni kod uz byl odeslan.
	 *
	 * @param string $type    konverze, napr Heureka, Zbozi, GA
	 * @param int    $orderId ID objednavky
	 */
	public function send(string $type, int $orderId): void
	{
		$conversionSent = $this->sessionSection->get('conversionSent') ?: [];
		if (!is_array($conversionSent[$type])) {
			$conversionSent[$type] = [];
		}

		$conversionSent[$type][$orderId] = true;
		$this->sessionSection->set('conversionSent', $conversionSent);
	}

	public function clear(): void
	{
		$this->sessionSection->remove('conversionSent');
	}
}

