<?php declare(strict_types = 1);

namespace MeasuringCodes\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use MeasuringCodes\FrontModule\Model\TypesList;
use Nette\Utils\Json;

class TypesForm extends BaseControl
{
	protected string $settingsPrefix;

	protected TypesList $typesList;

	public function __construct(string $settingsPrefix, TypesList $typesList)
	{
		$this->settingsPrefix = $settingsPrefix;
		$this->typesList      = $typesList;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		foreach ($this->typesList->getTypes(false) as $type) {
			$container = $form->addContainer($type->getKey(), $type->getName());

			$d = [];
			foreach ($this->settings->get('measuringCodes' . ucfirst($this->settingsPrefix) . ucfirst($type->getKey()), [], false) as $lang => $vals) {
				foreach ($vals as $k => $v) {
					$d[$k][$lang] = $v;
				}
			}

			$container->addBool('enable', 'measuringCodes.enable')
				->setIsMultilanguage();

			foreach ($type->getFields() as $k => $field) {
				$label = sprintf('measuringCodes.types.%s.%s', $type->getKey(), $k);
				if ($field->getType() === 'text') {
					$container->addText($k, $label)
						->setMaxLength(255)
						->setIsMultilanguage();
				} else if ($field->getType() === 'bool') {
					$container->addBool($k, $label)
						->setIsMultilanguage();
				}
			}

			$container->setDefaults($d);
		}

		$form->addSubmit('submit', 'default.save');
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form)
	{
		$this->em->beginTransaction();
		try {
			$presenter = $this->getPresenter();

			$forSave = [];
			$tmp     = [];
			foreach ($form->convertMultilangValuesToArray() as $lang => $values) {
				foreach ($values as $name => $vals) {
					$baseKey = 'measuringCodes' . ucfirst($this->settingsPrefix) . ucfirst($name);

					$tmp[$baseKey][$lang] = $vals;
				}
			}

			foreach ($tmp as $k => $v) {
				$forSave[$k] = Json::encode($v);
			}

			$this->settings->saveMulti($forSave);

			$presenter->flashMessageSuccess('default.saved');
			$presenter->redrawControl('flashes');

			$this->em->commit();
		} catch (\Exception $e) {
			$this->em->rollback();
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}
		$this->settings->clearCache();
		$this->redrawControl('form');

		return true;
	}
}
