<?php declare(strict_types = 1);

namespace MeasuringCodes\AdminModule\Presenters;

use MeasuringCodes\AdminModule\Components\ITypesFormFactory;
use Nette\Application\UI\Multiplier;

class DefaultPresenter extends BasePresenter
{
	const ICON_DEFAULT = 'fas fa-code';

	protected function startup()
	{
		parent::startup();
		$this->setHeader('measuringCodes.title.measuringCodes', self::ICON_DEFAULT);
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault()
	{
		//		$this['navigation']->setData(['header' => [
		//			[
		//				'title'  => 'eshopProductsComparison.menu.updateExport',
		//				'link'   => $this->link(':EshopProductsComparison:Cron:Export:porovnavace',
		//					['type' => ['zbozi', 'google', 'heureka']]),
		//				'target' => '_blank',
		//				'ico'    => 'fas fa-sync',
		//			],
		//		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentTypesForms(ITypesFormFactory $factory): Multiplier
	{
		return new Multiplier(function($settingsPrefix) use ($factory) {
			return $factory->create($settingsPrefix);
		});
	}
}
