<?php declare(strict_types = 1);

namespace MeasuringCodes\DI;

use Core\DI\CompilerExtension;
use Core\Model\Helpers\Strings;
use Nette;

class  MeasuringCodesExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['MeasuringCodes' => 'MeasuringCodes\*Module\Presenters\*Presenter']);
		$builder = $this->getContainerBuilder();

		$factories = [
			'default' => $builder->getDefinition('measuringCodes.front.typeControlFactory'),
		];
		foreach ($builder->parameters['measuringCodes']['typesList'] as $k => $row) {
			if (isset($row['factory'])) {
				if (Strings::contains($row['factory'], '.'))
					$factory = $builder->getDefinition($row['factory']);
				else
					$factory = $builder->getDefinitionByType($row['factory']);

				$factories[$k] = $factory;
			}
		}

		if ($factories) {
			$builder->getDefinition('measuringCodes.front.typesList')
				->addSetup('setFactories', [$factories]);
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('MeasuringCodes\Model\MeasuringCodesConfig::setParams($this->parameters[\'measuringCodes\']);');
	}
}
