<?php declare(strict_types = 1);

namespace MeasuringCodes\ErrorModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\ErrorPresenter;
use MeasuringCodes\FrontModule\Components\ITypeControlFactory;
use MeasuringCodes\FrontModule\Model\TypesList;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ErrorPresenterSubscriber implements EventSubscriberInterface
{
	protected ITypeControlFactory $typeControlFactory;

	protected TypesList $typesList;

	public function __construct(ITypeControlFactory $typeControlFactory, TypesList $typesList)
	{
		$this->typeControlFactory = $typeControlFactory;
		$this->typesList          = $typesList;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ErrorPresenter::class . '::beforeRender' => 'beforeRender',
		];
	}

	/**
	 * Vložení obecných kódů na všechny stránky
	 *
	 * @param ControlEvent $event
	 */
	public function beforeRender(ControlEvent $event): void
	{
		/** @var FrontPresenter $presenter */
		$presenter = $event->control;

		// Vlozeni obechnych na kazdou stranku
		foreach ($this->typesList->getTypes() as $type) {
			if (!$type->isActive() || empty($type->getPositions()))
				continue;

			foreach ($type->getPositions() as $pos) {
				if ($pos === 'head') {
					$component = $this->typeControlFactory->create($type);
					$presenter->addHeadComponent($component, $type->getKey());

					if ($type->getKey() === 'googleAnalytics') {
						$googleAdsType = $this->typesList->getType('googleAds');

						if ($googleAdsType && $googleAdsType->isActive())
							$component->setParam('googleAds', $googleAdsType->getFieldValue('ads_id'));
					}
				} else if ($pos === 'bodyStart') {
					$presenter->addBodyStartComponent($this->typeControlFactory->create($type), $type->getKey());
				} else if ($pos === 'bodyEnd') {
					$presenter->addBodyEndComponent($this->typeControlFactory->create($type), $type->getKey());
				}
			}
		}
	}
}
