<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\UI\BaseControl;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class GTagEventControl extends BaseControl
{
	protected Type $type;

	protected string $eventName;

	protected array $data = [];

	protected bool $useSnippet = true;

	public function __construct(Type $type, string $eventName)
	{
		$this->type      = $type;
		$this->eventName = $eventName;
	}

	public function render(): void
	{
		$file = $this->type->getTemplate('event');
		if (!$file)
			return;

		$this->template->type       = $this->type;
		$this->template->eventName  = $this->eventName;
		$this->template->data       = $this->data;
		$this->template->useSnippet = $this->useSnippet;
		$this->template->render($file);
	}

	public function setData(array $data): void
	{
		$this->data = $data;
	}

	public function useSnippet(bool $use = true): void
	{
		$this->useSnippet = $use;
	}
}
