<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Components;

use Core\Model\Providers\BaseComponentPack;
use MeasuringCodes\FrontModule\Model\Dao\Type;

class TypeControl extends BaseComponentPack
{
	protected Type $type;

	protected array $templateParams = [];

	public function __construct(Type $type)
	{
		$this->type = $type;
	}

	public function render(): void
	{
		$file = $this->type->getTemplate($this->renderFile);
		if (!$file)
			return;

		$this->template->setParameters($this->templateParams);
		$this->template->type = $this->type;
		$this->template->render($file);
	}

	public function setParam(string $key, $value): self
	{
		$this->templateParams[$key] = $value;

		return $this;
	}
}
