<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Dao;

use Core\Model\Helpers\Strings;
use MeasuringCodes\FrontModule\Components\ITypeControlFactory;

class Type
{
	protected string $key;

	protected string $name;

	protected bool $isActive;

	/** @var Field[] */
	protected array $fields = [];

	protected array $positions = [];

	public array $rawFields = [];

	protected array $templates = [];

	/** @var null|ITypeControlFactory */
	public $factory = null;

	public function __construct(string $key, string $name, bool $isActive, array $positions,
	                            array $templates = [])
	{
		$this->key       = $key;
		$this->name      = $name;
		$this->isActive  = $isActive;
		$this->positions = $positions;
		$this->templates = $templates;
	}

	public function getKey(): string { return $this->key; }

	public function getName(): string { return $this->name; }

	public function isActive(): bool { return $this->isActive; }

	public function addField(Field $field): void
	{
		$this->fields[$field->getKey()] = $field;
	}

	public function setActive(bool $active = true): void
	{
		$this->isActive = $active;
	}

	/** @return Field[] */
	public function getFields(): array { return $this->fields; }

	public function getField(string $key): ?Field { return $this->fields[$key] ?? null; }

	public function getFieldValue(string $key): ?string
	{
		$field = $this->getField($key);

		return $field ? $field->getValue() : null;
	}

	public function getPositions(): array { return $this->positions; }

	public function getTemplate(string $fileName): ?string
	{
		if (isset($this->templates[$fileName])) {
			return $this->templates[$fileName];
		}

		$file = sprintf('%smeasuringCodes/%s/%s.latte', PACKAGE_MEASURINGCODES_DIR, $this->getKey(), $fileName);
		if (file_exists($file))
			return $file;

		return null;
	}
}
