<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Helpers;

use EshopCatalog\FrontModule\Model\Dao\Product;

class DataLayerHelper
{
	public static function getProduct(Product $product): array
	{
		$data = [
			'name'     => $product->getName(),
			'id'       => $product->getId(),
			'price'    => strval($product->getBasePrice()),
			'category' => $product->defaultCategory->name,
		];

		if ($product->getManufacturer()) {
			$data['brand'] = $product->getManufacturer()->name;
		}

		return $data;
	}
}
