<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Helpers;

use EshopCatalog\DI\EshopCatalogExtension;
use EshopCatalog\FrontModule\Model\Dao\Product;
use MeasuringCodes\FrontModule\Components\GTagEventControl;
use MeasuringCodes\FrontModule\Components\IGTagEventControlFactory;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\FrontModule\Model\TypesList;
use Nette\Application\IPresenter;

class GTagEventHelper
{
	public static function getTypeIfAllowed(TypesList $typesList): ?Type
	{
		$type = $typesList->getType('googleAnalytics');
		if (!$type->isActive() || !$type->getFieldValue('enableEcommerce') || !class_exists(EshopCatalogExtension::class)) {
			return null;
		}

		return $type;
	}

	public static function getComponent(IPresenter $presenter, IGTagEventControlFactory $factory, string $eventName, Type $type,
	                                    ?string $componentNameSuffix = null): ?GTagEventControl
	{
		$component = $factory->create($type, $eventName);
		if ($eventName === 'purchase') {
			$component->useSnippet(false);
			$presenter->addHeadComponent($component, $type->getKey() . '_' . $eventName . ($componentNameSuffix ? '_' . $componentNameSuffix : ''));
		} else {
			$presenter->addBodyEndComponent($component, $type->getKey() . '_' . $eventName . ($componentNameSuffix ? '_' . $componentNameSuffix : ''));
		}

		return $component;
	}

	public static function getItemFromProduct(Product $product): array
	{
		$item = [
			'id'       => strval($product->getId()),
			'name'     => $product->getName(),
			'category' => $product->defaultCategory->name,
			'price'    => self::formatNumber($product->getPrice()),
			'quantity' => 1,
		];

		if ($product->getManufacturer()) {
			$item['brand'] = $product->getManufacturer()->name;
		}

		return $item;
	}

	public static function formatNumber($price): string
	{
		return str_replace(',', '.', strval($price));
	}
}
