<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model\Subscribers;

use Core\Model\Notifiers\MailNotifiers\LogNotifier;
use MeasuringCodes\FrontModule\Model\TypesList;
use MeasuringCodes\Model\MeasuringCodesConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Entities\EntityManagerDecorator;
use Tracy\Debugger;
use Users\Model\Event\UserEvent;

class RegisterFormSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	protected TypesList $typesList;

	public function __construct(EntityManagerDecorator $em, TypesList $typesList)
	{
		$this->em        = $em;
		$this->typesList = $typesList;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'users.registerForm.afterSave' => 'formSuccess',
		];
	}

	public function formSuccess(UserEvent $event): void
	{
		if ((!MeasuringCodesConfig::load('enabledInTestMode', false) && CORE_TEST_MODE) || !MeasuringCodesConfig::load('enabled', false))
			return;

		$ecoMailType = $this->typesList->getType('ecoMail');
		if ($ecoMailType && $ecoMailType->isActive()) {
			$appId  = $ecoMailType->getFieldValue('appId');
			$listId = $ecoMailType->getFieldValue('listId');
			$user   = $event->user;
			$values = $event->data['formValues'];

			if ($appId && $listId && $values->newsletterSubscribe) {
				try {
					$ecoMailApi = new \Ecomail($appId);

					$ecoMailApi->addSubscriber($listId, [
						'subscriber_data'        => [
							'name'    => $user->getName(),
							'surname' => $user->getLastname(),
							'email'   => $user->getEmail(),
							'company' => null,
							'city'    => null,
							'street'  => null,
							'zip'     => null,
							'country' => null,
							'phone'   => null,
						],
						'trigger_autoresponders' => true,
						'update_existing'        => true,
						'resubscribe'            => true,
						'skip_confirmation'      => true,
					]);
				} catch (\Exception $e) {
					$msg = sprintf("Failed export data to ecomail: user ='%s' (%s: %s) - %s",
						$values->email, $e->getFile(), $e->getLine(), $e->getMessage());

					Debugger::log($msg, 'eshopordersConversion');
					LogNotifier::toDevelopers($msg, 'Ecomail - %siteDomain%');
				}
			}
		}
	}
}
