<?php declare(strict_types = 1);

namespace MeasuringCodes\FrontModule\Model;

use Core\Model\Application\AppState;
use Core\Model\Settings;
use Core\Model\Sites;
use Core\Model\SystemConfig;
use MeasuringCodes\FrontModule\Model\Dao\Field;
use MeasuringCodes\FrontModule\Model\Dao\Type;
use MeasuringCodes\Model\MeasuringCodesConfig;
use Nette\Localization\ITranslator;

class TypesList
{
	protected ITranslator $translator;

	protected Settings $settings;

	protected Sites $sites;

	/** @var Type[]|null */
	protected ?array $cTypes = null;

	protected array $factories = [];

	public function __construct(ITranslator $translator, Settings $settings, Sites $sites)
	{
		$this->translator = $translator;
		$this->settings   = $settings;
		$this->sites      = $sites;
	}

	public function getType(string $key): ?Type
	{
		return $this->getTypes()[$key] ?? null;
	}

	/**
	 * @return Type[];
	 */
	public function getTypes(bool $withCookieFilter = true): array
	{
		if (is_null($this->cTypes)) {
			$this->cTypes = [];
			$locale       = $this->translator->getLocale();
			$siteIdent    = ucfirst($this->sites->getCurrentSite()->getIdent());


			foreach (MeasuringCodesConfig::load('typesList', []) as $key => $row) {
				if (!$row['enable'])
					continue;

				$settings = $this->settings->get('measuringCodes' . $siteIdent . ucfirst($key), '', false);

				$type = new Type(
					$key,
					$this->translator->translate(sprintf('measuringCodes.types.%s.name', $key)),
					$settings[$locale]['enable'] ? true : false,
					$row['positions'] ?: [],
					$row['templates'] ?: [],
				);

				$allowCookies = AppState::getState('allowCookieServices', null);
				if ($withCookieFilter && SystemConfig::load('cookieBar.enable', false) && is_array($allowCookies)
					&& !in_array($type->getKey(), $allowCookies)
					&& !in_array($type->getKey(), SystemConfig::load('cookieBar.defaultsAllowed', [])) // pokud je v poli sluzeb netvorici si cookie soubory, tak neblokovat
					&& !in_array($type->getKey(), SystemConfig::load('cookieBar.servicesWithConsentMode', [])) //  pokud sluzba umi bezet v modu bez cookie, tak neblokovat
				) {
					$type->setActive(false);
				}

				foreach ($row['fields'] as $v) {
					$tmp = explode(':', $v);

					$field = new Field(
						$tmp[0],
						$tmp[1] ?? 'text',
						$settings[$locale][$tmp[0]] ?? null,
					);

					$type->addField($field);
				}

				$type->rawFields = $settings ?: [];
				$type->factory   = $this->factories[$key] ?? $this->factories['default'];

				$this->cTypes[$key] = $type;
			}
		}

		return $this->cTypes;
	}

	public function setFactories(array $factories): void
	{
		$this->factories = $factories;
	}
}
