<?php declare(strict_types = 1);

namespace MeasuringCodes\Model;

use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;
use Nette\Utils\DateTime;

class EcoMail
{
	public static function getSubscriberFromCustomer(Customer $customer): array
	{
		$addr = $customer->getAddressInvoice();

		return [
			'name'    => $addr->getFirstName(),
			'surname' => $addr->getLastName(),
			'email'   => $addr->email,
			'company' => $addr->getCompany(),
			'city'    => $addr->getCity(),
			'street'  => $addr->getStreet(),
			'zip'     => $addr->getPostal(),
			'country' => $addr->getCountry() ? $addr->getCountry()->getName() : 'CZ',
			'phone'   => $addr->phone,
		];
	}

	public static function getTransactionFromOrder(Order $order): array
	{
		$timestamp = $order->getCreatedTime()->getTimestamp();

		$transactionItems = [];
		$addr             = $order->getAddressInvoice();

		foreach ($order->getOrderItems()->toArray() as $orderItem) {
			/** @var OrderItem $orderItem */
			$transactionItems[] = [
				'code'      => $orderItem->getProductId(),
				'title'     => $orderItem->getOrderItemText()->getName(),
				'price'     => round((float) $orderItem->getPrice(), 2),
				'amount'    => (int) $orderItem->getQuantity(),
				'timestamp' => $timestamp,
			];
		}

		return [
			'transaction'       => [
				'order_id'  => $order->getId(),
				'email'     => $addr->getEmail(),
				'shop'      => $order->site->getIdent(),
				'amount'    => round((float) $order->getPriceItems(), 2),
				'shipping'  => round((float) $order->getPaySpedPrice(), 2),
				'city'      => $addr->getCity(),
				'country'   => $addr->getCountry() ? $addr->getCountry()->getName() : 'CZ',
				'timestamp' => $timestamp,
			],
			'transaction_items' => $transactionItems,
		];
	}
}
