<?php declare(strict_types = 1);

namespace MeasuringCodes\Model\Helpers;

use Core\Model\Helpers\BaseService;
use MeasuringCodes\FrontModule\Model\Helpers\typ;
use Nette\Http\SessionSection;
use Nette\SmartObject;
use Nette\Http\Session;

class TrackingHelper extends BaseService
{
	use SmartObject;

	/** @var SessionSection */
	protected SessionSection $sessionSection;

	public function __construct(Session $session)
	{
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}

	/** Zkontroluje, jestli konkretni merici kod uz byl odeslan
	 *
	 * @param $type    typ konverze, napr Heureka, Zbozi, GA
	 * @param $orderId int ID objednavky
	 *
	 * @return bool
	 */
	public function canSend($type, $orderId)
	{
		if (empty($this->sessionSection->conversionSent[$type][$orderId])) {
			return true;
		} else {
			return false;
		}
	}

	/** Nastavi do session priznak, ze tento konkretni konverzni kod uz byl odeslan.
	 *
	 * @param $type    typ konverze, napr Heureka, Zbozi, GA
	 * @param $orderId int ID objednavky
	 */
	public function send($type, $orderId)
	{
		if (!is_array($this->sessionSection->conversionSent[$type])) {
			$this->sessionSection->conversionSent[$type] = [];
		}
		$this->sessionSection->conversionSent[$type][$orderId] = true;
	}
}

