<?php declare(strict_types = 1);

namespace Mojedpd\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\ArrayCollection;
use EshopOrders\Model\Entities\Order;
use Mojedpd\Model\Entities\MojedpdOrder;

/**
 * class OrdersExported
 * @package MoneyS3\Model
 *
 * @method OrderExported|object|null getReference($id)
 * @method OrderExported[]|null getAll()
 * @method OrderExported|null get($id)
 */
class OrdersExported extends BaseEntityService
{

	/**
	 * Vrati seznam objednavek, ktere jeste nebyly exportovany do XML. Možno vyfiltrovat podle id objednávek
	 *
	 * @param array $filtrIds
	 *
	 * @return ZasilkovnaOrder[]
	 */
	public function getOrdersNotExported(array $filtrIds = [])
	{
		$expr = $this->em->getExpressionBuilder();

		//objednavky ktere nejsou v seznamu zpracovanych objednavek
		$ordersQuery = $this->em->getRepository(MojedpdOrder::class)->createQueryBuilder('dpdo')
			->select('o, dpdo, oad, oai, os, s')
			->join('dpdo.order', 'o')
			->leftJoin('o.addressDelivery', 'oad')
			->leftJoin('o.addressInvoice', 'oai')
			->leftJoin('o.spedition', 'os')
			->leftJoin('os.spedition', 's')
			->where('dpdo.exported IS NULL')
			->orderBy('o.id')->groupBy('o.id');

		if (!empty($filtrIds))
			$ordersQuery->andWhere('dpdo.order IN (:ids)')->setParameter('ids', $filtrIds);

		$orders = $ordersQuery->getQuery()->getResult();

		return $orders;
	}
}
