<?php


namespace Mojedpd\Model;

use EshopOrders\Model\Entities\Order;
use Kdyby\Doctrine\EntityManager;
use Mojedpd\Model\Entities\MojedpdOrder;
use SoapClient;
use SoapFault;
use Tracy\Debugger;

class OrderApiService
{
	/** @var array */
	protected $mojedpd;

	/** @var EntityManager */
	protected $em;

	public function __construct(array $mojedpd, EntityManager $em)
	{
		$this->mojedpd = $mojedpd;
		$this->em      = $em;
	}

	/**
	 * @param MojedpdOrder[] $orders
	 *
	 * @return array
	 * @throws SoapFault
	 */
	public function generateOrderOverApi(array $orders): array
	{
		$gw = new SoapClient("https://www.mojedpd.cz/IT4EMWebServices/eshop/ShipmentServiceImpl?wsdl", []);

		$result = [
			'ok'    => 0,
			'error' => 0,
		];

		$data                 = [
			'wsUserName'      => $this->mojedpd['userName'],
			'wsPassword'      => $this->mojedpd['userPassword'],
			'wsLang'          => 'CZ',
			'applicationType' => 9,
			'priceOption'     => 'WithoutPrice',
		];
		$data['shipmentList'] = [];
		$data['manifestList'] = [];


		foreach ($orders as $dpdO) {
			/** @var MojedpdOrder $dpdO */
			try {
				$order                                           = $dpdO->getOrder();
				$adress                                          = $order->getAddressDelivery();
				$data['shipmentList']['shipmentReferenceNumber'] = (string) $order->getId();
				$data['shipmentList']['payerId']                 = $this->mojedpd['payerId'];
				$data['shipmentList']['senderAddressId']         = $this->mojedpd['senderAddressId'];
				$data['shipmentList']['receiverName']            = $adress->getFirstName() . ' ' . $adress->getLastName();
				$data['shipmentList']['receiverCountryCode']     = 'CZ';
				$data['shipmentList']['receiverZipCode']         = $adress->getPostal();
				$data['shipmentList']['receiverCity']            = $adress->getCity();
				$data['shipmentList']['receiverStreet']          = $adress->getStreet();
				$data['shipmentList']['receiverHouseNo']         = $adress->getIdNumber();
				$data['shipmentList']['receiverPhoneNo']         = $adress->getPhone();
				$data['shipmentList']['mainServiceCode']         = '1';
				$data['shipmentList']['parcels']                 = [
					'parcelReferenceNumber' => (string) $order->getId(),
					'weight'                => 2,
				];

				$status = $gw->createShipment($data); //Zasilka se nahraje na serveru, ale nelze videt v mojedpd, neumoznuji to.


				/** TODO  Mojedpd neumoznuje videt zasilky nahrane pres API musí se dodělat výpis zásilek, editace štítků, objednání svozu atd.*/


				$dpdO->export('api');
				$this->em->persist($dpdO)->flush();
				$result['ok']++;
			} catch (SoapFault $e) {
				Debugger::log($e->getMessage(), 'mojedpdApi');
				$result['error']++;
			}
		}

		return $result;
	}

}
