<?php


namespace Mojedpd\Model;

use EshopOrders\Model\Entities\Order;
use Kdyby\Doctrine\EntityManager;
use Mojedpd\Model\Entities\MojedpdOrder;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class OrderCsvService
{

	/** @var EntityManager */
	protected $em;

	public function __construct(EntityManager $em)
	{
		$this->em = $em;
	}

	public function generateOrderCsv(array $orders): array
	{
		$result = [
			'ok'    => 0,
			'error' => 0,
		];

		$this->em->beginTransaction();
		try {
			$byService = [];
			foreach ($orders as $v)
				$byService[$v->service][] = $v;

			$tmpDir = TMP_DIR . '/mojedpdExport/' . (new DateTime())->format('Y-m-d-H-i-s');
			FileSystem::createDir($tmpDir);

			if (isset($byService['dpdPrivate'])) {
				$file = fopen($tmpDir . '/dpdPrivate.csv', 'w');
				fwrite($file, implode(';', ['Name', 'Address', 'City', 'Zip', 'Country', 'DPD Service', 'Phone', 'Email', 'Currency', 'Is COD', 'COD price']) . PHP_EOL);

				foreach ($byService['dpdPrivate'] as $v) {
					/** @var MojedpdOrder $v */
					$d   = $v->getOrder()->getAddressDelivery();
					$cod = $v->getOrder()->getPayment()->getPayment()->getIdent() == 'cod' ? $v->getOrder()->getPrice() : 0;

					if ($cod && strtoupper($v->getOrder()->currency) == 'CZK') {
						$cod = (int) round($cod);
					}

					$name = $d->getFirstName() . ' ' . $d->getLastName();
					if ($d->getCompany())
						$name .= ' (' . $d->getCompany() . ')';
					fwrite($file, implode(';', [trim($name), $d->getStreet(), $d->getCity(), $d->getPostal(), strtoupper($d->getCountry()->getId()), 40054, $d->getPhone(), $d->getEmail(), $cod > 0 ? 'CZK' : '', $cod > 0 ? '1' : '', $cod > 0 ? number_format($cod, 2, '.', ' ') : '']) . PHP_EOL);

					$v->export('csv');
					$this->em->persist($v);
				}

				fclose($file);

				$result['file'] = $tmpDir . '/dpdPrivate.csv';
			}

			$this->em->flush();
			$this->em->commit();
		} catch (\Exception $e) {
			if ($this->em->getConnection()->isTransactionActive())
				$this->em->rollback();
			Debugger::log($e->getMessage(), 'mojedpdCsv');
			$result['ok'] = 0;
		}


//		try {
//			$file = fopen(WWW_DIR . "/uploads/mojedpd/orders.csv", 'w');
//
//			//hlavicka souboru
//			$header = ['DPD_SLUZBA', 'JMENO_ZAKAZNIKA', 'ADRESA_PRIJEMCE', 'MESTO', 'PSC', 'ZEME', 'TELEFON',
//			           'EMAIL_ZAKAZNIKA', 'CASTKA', 'MENA', 'TYP_PLATBY', 'ID_VYD_MISTA', 'TELEFON_PRO_AVIZACI'];
//			fputcsv($file, $header);
//
//			foreach ($orders as $dpdO) {
//				/** @var MojedpdOrder $dpdO */
//				$order  = $dpdO->getOrder();
//				$adress = $order->getAddressDelivery();
//				// DPD_SLUZBA: DPD Classic - 1, DPD Private – 40054, Pickup – 50101 atd.
//				$data = ['40054', $adress->getFirstName() . ' ' . $adress->getLastName(),
//				         $adress->getStreet() . ' ' . $adress->getIdNumber(), $adress->getCity(), $adress->getPostal(),
//				         $adress->getCountry(), $adress->getPhone(), $adress->getEmail(), $order->getPrice(), $order->currency, 'doladit typ platby', $dpdO->getParcelId(), $adress->getPhone()];
//
//				fputcsv($file, $data);
//			}
//
//			fclose($file);
//			$result['ok']++;
//		} catch (\Exception $e) {
//			Debugger::log($e->getMessage(), 'mojedpdCsv');
//			$result['error']++;
//		}

		return $result;
	}
}
