<?php declare(strict_types = 1);

namespace Mojedpd\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\FrontModule\Model\Event\OrderFormEvent;
use EshopOrders\FrontModule\Model\Event\SaveOrderFormDataEvent;
use EshopOrders\FrontModule\Model\Event\SetOrderFormDataEvent;
use EshopOrders\Model\Entities\Spedition;
use Kdyby\Doctrine\EntityManager;
use Nette\Localization\ITranslator;
use Mojedpd\Model\Entities\MojedpdOrder;

class OrderFormSubscriber implements EventSubscriber
{
	/** @var array */
	protected $conf;

	/** @var EntityManager */
	protected $em;

	/** @var ITranslator */
	protected $translator;

	public function __construct(array $conf, EntityManager $em, ITranslator $translator)
	{
		$this->conf       = $conf;
		$this->em         = $em;
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.createOrderForm'   => ['createOrderForm', 100],
			'eshopOrders.setOrderFormData'  => ['setOrderFormData', 100],
			'eshopOrders.orderFormValidate' => ['orderFormValidate', 100],
			'eshopOrders.orderBeforeSave'   => ['orderBeforeSave', 100],
		];
	}

	public function createOrderForm(OrderFormEvent $event): void
	{
		$form    = $event->form;
		$methods = $this->getMojedpdSpeditionIds();

		// Pokud se jedná o DPD Pickup tak zobrazit select výdejních míst
		// TODO seznam výdejních míst udělat na frontu přes js
		if (isset($methods['dpdPickup'])) {
			$json  = file_get_contents('http://pickup.dpd.cz/api/get-all');
			$obj   = json_decode($json);
			$items = [];

			if ($obj->{'status'} == 'ok')
				foreach ($obj->{'data'}->{'items'} as $item) {
					$items[$item->{'id'}] = $item->{'city'} . ', ' . $item->{'street'} . ' ' . $item->{'house_number'} . ', ' . $item->{'company'};
				}

			$form->addSelect('mojedpdPickup', 'mojedpd.orderForm.mojedpdPickup', $items)
				->addConditionOn($form['spedition'], BaseForm::EQUAL, $methods['dpdPickup'])->setRequired('mojedpd.orderForm.mojedpdIdMissing');
			$form['mojedpdPickup']->getControlPrototype()->class[] = 'orderFormMojedpdPickup';
		}
	}

	public function setOrderFormData(SetOrderFormDataEvent $event): void
	{
		$data = $event->data;
		$form = $event->form;

		if ($form->getComponent('mojedpdPickup', false))
			$form['mojedpdPickup']->setDefaultValue($data['mojedpdPickup']);
	}

	public function orderFormValidate(OrderFormEvent $event): void
	{
	}

	public function orderBeforeSave(OrderEvent $event): void
	{
		$values  = $event->formData;
		$methods = $this->getMojedpdSpeditionIds();
		if ($values['spedition'] == $methods['dpdPickup']) {
			$entity = new MojedpdOrder(MojedpdOrder::SERVICE_DPD_PICKUP, $event->order, $values['mojedpdPickup']);
			$json   = file_get_contents('http://pickup.dpd.cz/api/get-parcel-shop-by-id?id=' . $values['mojedpdName']);
			$obj    = json_decode($json);
			if ($obj->{'status'} == 'ok') {
				$entity->parcelName    = $obj->{'data'}->{'company'};
				$entity->parcelAddress = $obj->{'data'}->{'street'} . ' ' . $obj->{'data'}->{'house_number'} . ', ' . $obj->{'data'}->{'postal'} . ' ' . $obj->{'data'}->{'city'};
				$this->em->persist($entity);
			}
		} else if ($values['spedition'] == $methods['dpdPrivate']) {
			$entity = new MojedpdOrder(MojedpdOrder::SERVICE_DPD_PRIVATE, $event->order);
			$this->em->persist($entity);
		}
	}

	protected function getMojedpdSpeditionIds(): array
	{
		$result = [];
		foreach ($this->em->getRepository(Spedition::class)->createQueryBuilder('s')
			         ->select('s.id, s.ident')
			         ->where('s.ident IN (:ident)')->setParameter('ident', ['dpdPickup', 'dpdPrivate'])
			         ->getQuery()->useResultCache(true, 30)->getArrayResult() as $row)
			$result[$row['ident']] = $row['id'];

		return $result;
	}
}
