<?php declare(strict_types = 1);

namespace Mojedpd\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="mojedpd__order")
 * @ORM\Entity
 */
class MojedpdOrder
{
	use MagicAccessors;

	const SERVICE_DPD_PRIVATE = 'dpdPrivate';
	const SERVICE_DPD_PICKUP  = 'dpdPickup';

	/**
	 * @var Order
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var string
	 * @ORM\Column(name="parcel_id", type="string", nullable=true)
	 */
	protected $parcelId;

	/**
	 * @var string
	 * @ORM\Column(name="parcel_name", type="string", nullable=true)
	 */
	public $parcelName;

	/**
	 * @var string
	 * @ORM\Column(name="parcel_address", type="string", nullable=true)
	 */
	public $parcelAddress;

	/**
	 * @var DateTime
	 * @ORM\Column(name="exported", type="datetime", nullable=true)
	 */
	private $exported;

	/**
	 * @var string
	 * @ORM\Column(name="export_type", type="string", nullable=true)
	 */
	private $exportType;

	/**
	 * @var string
	 * @ORM\Column(name="service", type="string", nullable=false)
	 */
	protected $service;

	public function __construct(string $service, Order $order, ?string $parcelId = null)
	{
		$this->service  = $service;
		$this->order    = $order;
		$this->parcelId = $parcelId;
	}

	public function getOrder(): Order { return $this->order; }

	public function getParcelId(): string { return $this->parcelId; }

	public function export(string $type, ?DateTime $datetime = null): self
	{
		$this->exportType = $type;
		$this->exported   = $datetime ?: new DateTime();

		return $this;
	}

	public function getExportType(): ?string { return $this->exportType; }

	public function getExported(): ?DateTime { return $this->exported; }

	public function getService(): string { return $this->service; }
}
