<?php


namespace Mojedpd\Model;

use EshopOrders\Model\Entities\Order;
use Kdyby\Doctrine\EntityManager;
use Mojedpd\Model\Entities\MojedpdOrder;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class OrderCsvService
{

	/** @var EntityManager */
	protected $em;

	public function __construct(EntityManager $em)
	{
		$this->em = $em;
	}

	public function generateOrderCsv(array $orders): array
	{
		$result = [
			'ok'    => 0,
			'error' => 0,
		];

		$this->em->beginTransaction();
		try {
			$byService = [];
			foreach ($orders as $v)
				$byService[$v->service][] = $v;

			$tmpDir = TMP_DIR . '/mojedpdExport/' . (new DateTime())->format('Y-m-d-H-i-s');
			FileSystem::createDir($tmpDir);

			if (isset($byService['dpdPrivate'])) {
				$file = fopen($tmpDir . '/dpdPrivate.csv', 'w');
				fwrite($file, implode(';', ['Name', 'Address', 'City', 'Zip', 'Country', 'DPD Service', 'Phone', 'Email', 'Currency', 'Is COD', 'COD price', 'Order']) . PHP_EOL);

				foreach ($byService['dpdPrivate'] as $v) {
					/** @var MojedpdOrder $v */
					$d   = $v->getOrder()->getAddressDelivery();
					$cod = $v->getOrder()->getPayment()->getPayment()->getIdent() == 'cod' ? $v->getOrder()->getPrice() : 0;

					if ($cod && strtoupper($v->getOrder()->currency) == 'CZK') {
						$cod = (int) round($cod);
					}

					$name = $d->getFirstName() . ' ' . $d->getLastName();
					if ($d->getCompany())
						$name .= ' (' . $d->getCompany() . ')';
					fwrite($file, implode(';', [trim($name), $d->getStreet(), $d->getCity(), $d->getPostal(), strtoupper($d->getCountry()->getId()), 40054, $d->getPhone(), $d->getEmail(), $cod > 0 ? 'CZK' : '', $cod > 0 ? '1' : '', $cod > 0 ? $cod : '0', $v->getOrder()->getId()]) . PHP_EOL);

					$v->export('csv');
					$this->em->persist($v);
				}

				fclose($file);

				$result['file'] = $tmpDir . '/dpdPrivate.csv';
			}

			$this->em->flush();
			$this->em->commit();
		} catch (\Exception $e) {
			if ($this->em->getConnection()->isTransactionActive())
				$this->em->rollback();
			Debugger::log($e->getMessage(), 'mojedpdCsv');
			$result['ok'] = 0;
		}

		return $result;
	}
}
