<?php declare(strict_types = 1);

namespace Mojedpd\CronModule\Presenters;

use Core\Model\Countries;
use Core\Model\Event\Event;
use Mojedpd\Model\Branches;
use Nette\DI\Attributes\Inject;

class DefaultPresenter extends BasePresenter
{
	#[Inject]
	public Countries $countriesService;

	#[Inject]
	public Branches $branches;

	public function actionBranches(string $id, string $country): void
	{
		$data    = [];
		$c       = $country;
		$country = $this->countriesService->get($country);

		if ($country && isset($this->branches::COUNTRIES[strtolower($country->getId())])) {
			foreach ($this->branches->getBranches($this->branches::COUNTRIES[strtolower($country->getId())]) as $row) {
				$data[(string) str_replace($c, '', $row->id)] = [
					'name' => $row->city . ', ' . $row->postcode . ', ' . $row->street . ' ' . $row->house_number . ', ' . $row->company,
				];
			}
		}

		$this->getPresenter()->sendJson($data);
	}

	public function actionCheckCompletedOrders(): void
	{
		set_time_limit(1000);
		$this->eventDispatcher->dispatch(new Event(), 'eshopOrders.orders.checkCompletedMojeDpd');
		$this->sendJson(['result' => 'ok']);
	}
}
