<?php declare(strict_types = 1);

namespace Mojedpd\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

final class Version20240514180817 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE mojedpd__order_parcel (id INT UNSIGNED AUTO_INCREMENT NOT NULL, order_id INT NOT NULL, parcel_id VARCHAR(255) DEFAULT NULL, parcel_number VARCHAR(255) DEFAULT NULL, INDEX IDX_F5A27E9F8D9F6D38 (order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE mojedpd__order_parcel ADD CONSTRAINT FK_F5A27E9F8D9F6D38 FOREIGN KEY (order_id) REFERENCES mojedpd__order (order_id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mojedpd__order ADD shipment_id VARCHAR(255) DEFAULT NULL');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE mojedpd__order_parcel');
		$this->addSql('ALTER TABLE mojedpd__order DROP shipment_id');
	}
}
